;___________________________________________

; 	TextPad Syntax Generator Script
;               -19.03.2005 A. Gleichmann
;		the syntaxfile must be addes to the jedit catalog file:
;		<MODE NAME="ahk" FILE="ahk.xml" FILE_NAME_GLOB="*.{ahk}"/>
;               -26.03.2005 A. Gleichmann 
;		  change the writung from the first part of the xml file for better reading
;___________________________________________

SetBatchLines, -1     ; Speeds up file operations.
SetWorkingDir, ..\..  ; Set it to the Editors folder.

TargetFile = jEdit\ahk.xml
FileDelete, %TargetFile%
;little tricky for performance reason
;do an loop, read for performance reason as the output file is not closed an open for each line
Loop, Read, %A_ScriptDir%\%A_ScriptName%, %TargetFile%
{
    FileAppend, <?xml version="1.0"?>`n
    FileAppend, `n
    FileAppend, <!DOCTYPE MODE SYSTEM "xmode.dtd">`n
    FileAppend, `n
    FileAppend, <!--`n
    FileAppend, `t19.03.2005 - A. Gleichmann`n
    FileAppend, `tAdded the AutoHotkeys Command`n
    FileAppend, `tthis file is based on the  JEdit batch.xml mode.`n
    FileAppend, -->`n
    FileAppend, `n
    FileAppend, <!-- The keywords and functions here defined are those of AutoHotkey Programm`n
    FileAppend,    JEdit keyword syntax file for AutoHotkey`n
    FileAppend,    Auto generated by A. Gleichmanns JEdit Syntax Generator Script`n`n
    FileAppend,  -->`n
    
    FileAppend, <MODE>`n
    FileAppend, `t<PROPS>`n
    FileAppend, `t`t<PROPERTY NAME="lineComment" VALUE=";" />`n
    FileAppend, `t`t<PROPERTY NAME="wordBreakChars" VALUE="`,+-=&lt;&gt;/?^&amp;*" />`n
    FileAppend, `t`t<PROPERTY NAME="indentOpenBrackets" VALUE="{" />`n
    FileAppend, `t`t<PROPERTY NAME="indentCloseBrackets" VALUE="}" />`n
    FileAppend, `t`t<PROPERTY NAME="doubleBracketIndent" VALUE="false" />`n
    FileAppend, `t`t<PROPERTY NAME="lineUpClosingBracket" VALUE="true" />`n
    FileAppend, `t</PROPS>`n
    FileAppend, `t<RULES ESCAPE="``" IGNORE_CASE="TRUE" HIGHLIGHT_DIGITS="TRUE" DIGIT_RE="(0x[[:xdigit:]]+[lL]?|[[:digit:]]+(e[[:digit:]]*)?[lLdDfF]?)">`n
    FileAppend, `t`t<EOL_SPAN TYPE="COMMENT1">;</EOL_SPAN>`n
    FileAppend, `t`t<!-- Comparison operators -->`n
    FileAppend, `t`t<SEQ TYPE="OPERATOR">&lt;</SEQ>`n
    FileAppend, `t`t<SEQ TYPE="OPERATOR">&lt;=</SEQ>`n
    FileAppend, `t`t<SEQ TYPE="OPERATOR">&gt;=</SEQ>`n
    FileAppend, `t`t<SEQ TYPE="OPERATOR">&gt;</SEQ>`n
    FileAppend, `t`t<SEQ TYPE="OPERATOR">=</SEQ>`n
    FileAppend, `t`t<SEQ TYPE="OPERATOR">&lt;&gt;</SEQ>`n
    FileAppend, `t`t<!-- Arithmetic operators -->`n
    FileAppend, `t`t<SEQ TYPE="OPERATOR">+</SEQ>`n
    FileAppend, `t`t<SEQ TYPE="OPERATOR">-</SEQ>`n
    FileAppend, `t`t<SEQ TYPE="OPERATOR">*</SEQ>`n
    FileAppend, `t`t<SEQ TYPE="OPERATOR">/</SEQ>`n
    FileAppend, `t`t<SEQ TYPE="OPERATOR">\</SEQ>`n
    FileAppend, `t`t<SEQ TYPE="OPERATOR">:=</SEQ>`n
    FileAppend, `t`t<MARK_PREVIOUS AT_WHITESPACE_END="TRUE" EXCLUDE_MATCH="TRUE" TYPE="LABEL">:</MARK_PREVIOUS>`n
    FileAppend, `t`t<MARK_PREVIOUS AT_WHITESPACE_END="TRUE" EXCLUDE_MATCH="TRUE" TYPE="LABEL">`::</MARK_PREVIOUS>`n
    FileAppend, `n`n
    FileAppend,`t`t<KEYWORDS>`n
    break
}


;this doesn't require fancy cmd names for human reading,
;it just requires names to be highlighted. so getting first name only

Loop, Read, Syntax\CommandNames.txt, %TargetFile%
{
	checkLine=%a_loopreadline%
	gosub, checkComment
	IfEqual, rc, 0
		 FileAppend, `t`t`t<!-- %CurrCmd%  -->`n
	else {
	    CurrCmd =
	    FullCmd = %a_loopreadline%
	    
	    ;directives don't have first comma but a first space
	    ;so whichever is first, take it as end of cmd name
	    StringGetPos, cPos, FullCmd, `,
	    StringGetPos, sPos, FullCmd, %A_Space%
	    
	    IfLess, sPos, %cPos%
		    IfGreater, sPos, 0
			    StringLeft, CurrCmd, FullCmd, %sPos%
	    IfLess, cPos, %sPos%
		    IfGreater, cPos, 0
			    StringLeft, CurrCmd, FullCmd, %cPos%
	    IfLess, cPos, %sPos%
		    IfLess, cPos, 0
			    StringLeft, CurrCmd, FullCmd, %sPos%
	    IfLess, sPos, %cPos%
		    IfLess, sPos, 0
			    StringLeft, CurrCmd, FullCmd, %cPos%

	    StringReplace, FullCmd, FullCmd, ``n, `n, a
	    StringReplace, FullCmd, FullCmd, ``t, `t, a
    
	    StringReplace, CurrCmd, CurrCmd, [,, a
	    StringReplace, CurrCmd, CurrCmd, %a_space%,, a
	    
	    ;For a directive that has no parameters
	    IfEqual, CurrCmd,
		    CurrCmd = %FullCmd%
	
		;this check removes duplicates for loop and if
		IfNotEqual, CurrCmd,
			IfNotEqual, CurrCmd, %LastCmd%
				FileAppend, `t`t`t<KEYWORD1>%CurrCmd%</KEYWORD1>`n
	}	
	LastCmd = %CurrCmd%
}

FileAppend, `n`n, %TargetFile%
Loop, Read, Syntax\Keywords.txt, %TargetFile%
{
	CurrCmd = %a_loopreadline%

	checkLine=%CurrCmd%
	gosub, checkComment
	IfEqual, rc, 0
		FileAppend, `t`t`t<!-- %CurrCmd%  -->`n
	else {
		;this check removes duplicates for loop and if
		IfNotEqual, CurrCmd,
		    IfNotEqual, CurrCmd, %LastCmd%
			    FileAppend, `t`t`t<KEYWORD2>%CurrCmd%</KEYWORD2>`n
	}
	
	LastCmd = %CurrCmd%
}
FileAppend, `n`n, %TargetFile%
Loop, Read, Syntax\Variables.txt, %TargetFile%
{
	CurrCmd = %a_loopreadline%

	checkLine=%CurrCmd%
	gosub, checkComment
	IfEqual, rc, 0
		FileAppend, `t`t`t<!-- %CurrCmd%  -->`n
	else {
		;this check removes duplicates for loop and if
		IfNotEqual, CurrCmd,
		    IfNotEqual, CurrCmd, %LastCmd%
			    FileAppend, `t`t`t<KEYWORD3>%CurrCmd%</KEYWORD3>`n
	}
	
	LastCmd = %CurrCmd%
}
FileAppend, `n`n, %TargetFile%
Loop, Read, Syntax\Keys.txt, %TargetFile%
{
	CurrCmd = %a_loopreadline%

	checkLine=%CurrCmd%
	gosub, checkComment
	IfEqual, rc, 0
		FileAppend, `t`t`t<!-- %CurrCmd%  -->`n
	else {
		;this check removes duplicates for loop and if
		;keys are added with and without {}
		IfNotEqual, CurrCmd,
		    IfNotEqual, CurrCmd, %LastCmd% 
		    {
			    FileAppend, `t`t`t<LITERAL2>%CurrCmd%</LITERAL2>`n
			    FileAppend, `t`t`t<LITERAL2>{%CurrCmd%}</LITERAL2>`n
		    }
	}
	
	LastCmd = %CurrCmd%
}
FileAppend, `n`t`t</KEYWORDS>`n, %TargetFile%


FileAppend, `t</RULES>`n, %TargetFile%
FileAppend, </MODE>`n, %TargetFile%

return

checkComment:
	;comment check
	StringReplace, check, checkLine , %A_Space%,, A
	StringReplace, check, check, %A_Tab%,, A
	StringLeft, check, check, 1
	IfEqual, check, `;
		rc=0
	else
		rc=1
	return

